using System;
using System.Data;
using System.Data.SqlClient;
using STOREDPROC = gov.va.med.vbecs.Common.VbecsStoredProcs;

namespace gov.va.med.vbecs.DAL
{
	#region Header

	///<Package>Package: VBECS - VistA Blood Establishment Computer System</Package>
	///<Warning> WARNING: Per VHA Directive $VADIRECTIVE this class should not be modified</Warning>
	///<MedicalDevice> Medical Device #: $MEDDEVICENO</MedicalDevice>
	///<Developers>
	///	<Developer>Carl Jensen</Developer>
	///</Developers>
	///<SiteName>Hines OIFO</SiteName>
	///<CreationDate>08/25/2004</CreationDate>
	///<Note>The Food and Drug Administration classifies this software as a medical device.  As such, it may not be changed in any way. Modifications to this software may result in an adulterated medical device under 21CFR820, the use of which is considered to be a violation of US Federal Statutes.  Acquiring and implementing this software through the Freedom of information Act requires the implementor to assume total responsibility for the software, and become a registered manufacturer of a medical device, subject to FDA regulations</Note>
	///<summary>
	/// Address data access layer class.
	///</summary>

	#endregion
	
	public class OrderReport
	{
		///<Developers>
		///	<Developer>C. Jensen</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>8/29/2004</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="5497"> 
		///		<ExpectedInput>Date range that will return records</ExpectedInput>
		///		<ExpectedOutput>A count of at least 1</ExpectedOutput>
		///	</Case>
		///
		///<Case type="1" testid ="5498"> 
		///		<ExpectedInput>Invalid Dates</ExpectedInput>
		///		<ExpectedOutput>ArgumetnException</ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		///
		/// <summary>
		/// Returns the number of records
		/// </summary>
		/// <returns></returns>
		public static int GetMultiOrderReportCount(DateTime startDate, DateTime endDate, string divisionCode)
		{
			int count = 0;

			if (startDate == DateTime.MinValue || endDate == DateTime.MinValue)
			{
				throw new ArgumentException(Common.StrRes.SysErrMsg.Common.InvalidFormat("datetime").ResString);
			}

			SqlParameter[] prms =
			{
				new SqlParameter(STOREDPROC.GetReportMultiOrderHistoryCount.startdate, System.Data.SqlDbType.DateTime),
				new SqlParameter(STOREDPROC.GetReportMultiOrderHistoryCount.enddate, System.Data.SqlDbType.DateTime),
				new SqlParameter(STOREDPROC.GetReportMultiOrderHistoryCount.divisionCode, System.Data.SqlDbType.VarChar)
			};
			//
			prms[0].Value = startDate;
			prms[1].Value = endDate;
			prms[2].Value = Common.LogonUser.LogonUserDivisionCode;

			DataTable dt = Common.StoredProcedure.GetData(STOREDPROC.GetReportMultiOrderHistoryCount.StoredProcName, prms).Tables[0];
			//
			foreach(DataRow dr in dt.Rows)
			{
				count += (int)dr["Total"];
			}
			
			return count;
		}

		///<Developers>
		///	<Developer>C. Jensen</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>8/16/2004</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="5434"> 
		///		<ExpectedInput>Valid ordered test Guid</ExpectedInput>
		///		<ExpectedOutput>One record</ExpectedOutput>
		///	</Case>
		///
		///<Case type="1" testid ="5435"> 
		///		<ExpectedInput>Empty Guid</ExpectedInput>
		///		<ExpectedOutput>ArgumentException</ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		///
		/// <summary>
		/// Returns a DataTable representing the order report
		/// </summary>
		public static DataTable GetReportSingleOrderComponentHistory(Guid orderedComponentGuid)
		{	
			if (orderedComponentGuid == Guid.Empty)
			{
				throw new ArgumentException(Common.StrRes.SysErrMsg.Common.InvalidFormat("orderedComponentGuid").ResString);
			}

			SqlParameter[] prms =
			{
				new SqlParameter(STOREDPROC.GetReportSingleOrderComponentHistory.orderedcomponentguid, System.Data.SqlDbType.UniqueIdentifier),
				new SqlParameter(STOREDPROC.GetReportSingleOrderComponentHistory.divisionCode, System.Data.SqlDbType.VarChar)
			};
			//
			prms[0].Value = orderedComponentGuid;
			prms[1].Value = Common.LogonUser.LogonUserDivisionCode;
			//
			return Common.StoredProcedure.GetData(STOREDPROC.GetReportSingleOrderComponentHistory.StoredProcName, prms).Tables[0];
		}

		///<Developers>
		///	<Developer>C. Jensen</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>8/16/2004</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="5432"> 
		///		<ExpectedInput>Valid ordered test Guid</ExpectedInput>
		///		<ExpectedOutput>One record</ExpectedOutput>
		///	</Case>
		///
		///<Case type="1" testid ="5433"> 
		///		<ExpectedInput>Empty Guid</ExpectedInput>
		///		<ExpectedOutput>ArgumentException</ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		///
		/// <summary>
		/// Returns a DataTable representing the order report
		/// </summary>
		public static DataTable GetReportSingleOrderTestHistory(Guid orderedTestGuid)
		{	
			if (orderedTestGuid == Guid.Empty)
			{
				throw new ArgumentException(Common.StrRes.SysErrMsg.Common.InvalidFormat("orderedTestGuid").ResString);
			}

			SqlParameter[] prms =
			{
				new SqlParameter(STOREDPROC.GetReportSingleOrderTestHistory.orderedtestguid, System.Data.SqlDbType.UniqueIdentifier),
				new SqlParameter(STOREDPROC.GetReportSingleOrderTestHistory.divisionCode, System.Data.SqlDbType.VarChar)
			};
			//
			prms[0].Value = orderedTestGuid;
			prms[1].Value = Common.LogonUser.LogonUserDivisionCode;
			//
			return Common.StoredProcedure.GetData(STOREDPROC.GetReportSingleOrderTestHistory.StoredProcName, prms).Tables[0];
		}

		///<Developers>
		///	<Developer>C. Jensen</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>8/29/2004</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="5499"> 
		///		<ExpectedInput>Valid start date, end date and division code</ExpectedInput>
		///		<ExpectedOutput>At least one record</ExpectedOutput>
		///	</Case>
		///
		///<Case type="1" testid ="5500"> 
		///		<ExpectedInput>Invaldi Date Ranges</ExpectedInput>
		///		<ExpectedOutput>Argument Exceptions</ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		///
		/// <summary>
		/// Returns a DataTable representing the multi-order report
		/// BR_77.02 (technically, this one is implemented in the sproc)
		/// </summary>
		/// <param name="startDate"></param>
		/// <param name="endDate"></param>
		/// <param name="divisionCode"></param>
		/// <returns></returns>
		public static DataTable GetReportMultiOrderHistory(DateTime startDate, DateTime endDate, string divisionCode)
		{
			if (startDate == DateTime.MinValue || endDate == DateTime.MinValue)
			{
				throw new ArgumentException(Common.StrRes.SysErrMsg.Common.InvalidFormat("datetime").ResString);
			}

			SqlParameter[] prms =
			{
				new SqlParameter(STOREDPROC.GetReportMultiOrderHistory.startdate, System.Data.SqlDbType.DateTime),
				new SqlParameter(STOREDPROC.GetReportMultiOrderHistory.enddate, System.Data.SqlDbType.DateTime),
				new SqlParameter(STOREDPROC.GetReportMultiOrderHistory.divisionCode, System.Data.SqlDbType.VarChar)
			};
			//
			prms[0].Value = startDate;
			prms[1].Value = endDate;
			prms[2].Value = divisionCode;
			//
			return Common.StoredProcedure.GetData(STOREDPROC.GetReportMultiOrderHistory.StoredProcName, prms).Tables[0];
		}
	}
}
